/*
 * Decompiled with CFR 0.152.
 */
package com.service.product;

import com.dao.IndustrialInvoiceDao;
import com.dao.SarfaslDao;
import com.dto.LoginDto;
import com.dto.MainGroupDto;
import com.dto.ProductDto;
import com.dto.SarfaslDto;
import com.dto.SideGroupDto;
import com.dto.industrial.IndustrialSarfaslDto;
import com.dto.industrial.SarfaslType;
import com.utility.DbLogin;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import java.util.HashMap;

public class IndustrialProductService {
    private final IndustrialInvoiceDao dao;
    private final LoginDto login;
    private final SarfaslDao sarfaslDao;
    private boolean isIndustrial;

    public IndustrialProductService(DbLogin dbLogin) {
        this.dao = new IndustrialInvoiceDao(dbLogin);
        this.login = dbLogin.getLogin();
        this.sarfaslDao = new SarfaslDao(dbLogin.getDbConnection());
        this.isIndustrial = this.dao.isIndustrial();
    }

    public void checkWarehouseTypeValidity(Integer warehouseType) throws TncException {
        if (this.isIndustrial && (warehouseType == null || warehouseType < 1 || warehouseType > 3)) {
            throw new TncException(TncExceptionMessages.INVALID_INDUSTRIAL_WAREHOUSE_TYPE);
        }
        if (!this.isIndustrial && warehouseType != null) {
            throw new TncException(TncExceptionMessages.INDUSTRIAL_WAREHOUSE_TYPE_NOT_ALLOWED);
        }
    }

    public void insertMainGroupSarfasl(MainGroupDto dto) throws TncException {
        if (!this.isIndustrial) {
            return;
        }
        HashMap<String, String> groupSarfaslResults = new HashMap<String, String>();
        for (SarfaslType sarfaslType : SarfaslType.values()) {
            String colCodeMax = String.valueOf(this.dao.getNextMGroupColCode(sarfaslType.getDefaultSarfaslAsInt(), sarfaslType.getTypeId()));
            if (sarfaslType.reachedMaxMGroup(colCodeMax)) {
                throw new TncException(TncExceptionMessages.MAIN_GROUP_CAPACITY_FILLED);
            }
            groupSarfaslResults.put(sarfaslType.name(), colCodeMax);
            this.sarfaslDao.insert(SarfaslDto.builder().colcode(colCodeMax).sarfaslcode(colCodeMax).sarfaslname(dto.getName() + this.getTypeAppendix(sarfaslType.getRawTypeName())).mandeh(null).group(sarfaslType.getGroup()).mahiat(sarfaslType.getMahiat()).parent(null).type(sarfaslType.getTypeId()).build(), this.login);
        }
        this.dao.insertGroupSarfasl(dto.getCode(), groupSarfaslResults);
    }

    public void insertSideGroupSarfasl(SideGroupDto dto) throws TncException {
        if (!this.isIndustrial) {
            return;
        }
        HashMap<String, String> groupSarfaslResults = new HashMap<String, String>();
        IndustrialSarfaslDto parentGroupSarfasl = this.dao.getGroupSarfasl(dto.getMaingrouperpcode());
        String moienCodeMax = this.dao.getNextSGroupMoeenCode(parentGroupSarfasl.getMainSarfasl());
        for (SarfaslType sarfaslType : SarfaslType.values()) {
            String colCode = sarfaslType.getColCode(parentGroupSarfasl).trim();
            String sarfaslCode = colCode + moienCodeMax;
            Integer parentId = this.sarfaslDao.getParentId(colCode, this.login);
            groupSarfaslResults.put(sarfaslType.name(), sarfaslCode);
            this.sarfaslDao.insert(SarfaslDto.builder().colcode(colCode).moiencode(moienCodeMax).sarfaslcode(sarfaslCode).sarfaslname(dto.getName()).mandeh(null).group(sarfaslType.getGroup()).mahiat(sarfaslType.getMahiat()).parent(parentId).type(sarfaslType.getTypeId()).build(), this.login);
            this.sarfaslDao.updateParentAfterInsert(parentId, this.login);
        }
        this.dao.insertGroupSarfasl(dto.getMaingrouperpcode() + dto.getCode(), groupSarfaslResults);
    }

    public void insertProductSarfasl(ProductDto dto) {
        if (!this.isIndustrial) {
            return;
        }
        HashMap<String, String> groupSarfaslResults = new HashMap<String, String>();
        IndustrialSarfaslDto parentGroupSarfasl = this.dao.getGroupSarfasl(dto.getMaingroupid() + dto.getSidegroupid());
        String tafsiliCodeMax = this.dao.getNextProductTafsiliCode(parentGroupSarfasl.getMainSarfasl());
        for (SarfaslType sarfaslType : SarfaslType.values()) {
            String colCode = sarfaslType.getColCode(parentGroupSarfasl).trim();
            String moienCode = sarfaslType.getMoeenCode(parentGroupSarfasl).trim();
            String sarfaslCode = colCode + moienCode + tafsiliCodeMax;
            Integer parentId = this.sarfaslDao.getParentId(colCode + moienCode, this.login);
            groupSarfaslResults.put(sarfaslType.name(), sarfaslCode);
            this.sarfaslDao.insert(SarfaslDto.builder().colcode(colCode).moiencode(moienCode).tafzilicode(tafsiliCodeMax).sarfaslcode(sarfaslCode).sarfaslname(dto.getName()).mandeh(null).group(sarfaslType.getGroup()).mahiat(sarfaslType.getMahiat()).parent(parentId).type(sarfaslType.getTypeId()).build(), this.login);
            this.sarfaslDao.updateParentAfterInsert(parentId, this.login);
        }
        this.dao.insertArticleSarfasl(dto.getId(), groupSarfaslResults);
    }

    private String getTypeAppendix(String typeRawName) {
        return (!typeRawName.isEmpty() ? " - " : "") + typeRawName;
    }

    public void updateMGroupSarfasl(MainGroupDto dto, LoginDto myLogin) {
        if (!this.isIndustrial) {
            return;
        }
        IndustrialSarfaslDto mGroup = this.dao.getGroupSarfasl(dto.getCode());
        for (SarfaslType sarfaslType : SarfaslType.values()) {
            this.sarfaslDao.updateNameOfSarfasl(sarfaslType.getSarfaslCode(mGroup), dto.getName() + this.getTypeAppendix(sarfaslType.getRawTypeName()), myLogin);
        }
    }

    public void updateSGroupSarfasl(SideGroupDto dto) {
        if (!this.isIndustrial) {
            return;
        }
        IndustrialSarfaslDto mGroup = this.dao.getGroupSarfasl(dto.getMaingrouperpcode() + dto.getCode());
        for (SarfaslType sarfaslType : SarfaslType.values()) {
            this.sarfaslDao.updateNameOfSarfasl(sarfaslType.getSarfaslCode(mGroup), dto.getName(), this.login);
        }
    }

    public void updateProductSarfasl(ProductDto dto) {
        if (!this.isIndustrial) {
            return;
        }
        IndustrialSarfaslDto productSarfasl = this.dao.getArticleSarfasl(dto.getId());
        for (SarfaslType sarfaslType : SarfaslType.values()) {
            this.sarfaslDao.updateNameOfSarfasl(sarfaslType.getSarfaslCode(productSarfasl), dto.getName(), this.login);
        }
    }

    public Integer getWarehouseType(String mainGroupId) {
        if (!this.isIndustrial) {
            return null;
        }
        return this.dao.getWarehouseType(mainGroupId);
    }
}

